/* 
    AdeptXBBS REXX              Main BBS Script For The Spyders Web BBS

    Original Script by Chris Freeze.  Adapted and Updated by Paul Meyer     
*/

Arg line
 
signal on error
signal on halt

/* User Definable Variables */

  VoteBooth                   = "D:\Adept\Menus\Avote\Avote.Srx"
  AutoPost                    = "10Liners.Erx"
  TCPIPFlag                   = "D:\ADEPT\TEMP\PPP_IS_UP"
  SysOpPassword               = "ASHlooksgood" /* CaSe SeNSiTiVe */
  DoorsDisabled               = "FALSE"
  InternetSecurityLevel1      = 35
  InternetSecurityLevel2      = 35
  SysOpMenuSecurityLevel1     = 100
  SysOpMenuSecurityLevel2     = 100
  ScreenLength                = AdeptGetVar(line, 46)

  /* ANSI/AVATAR/RIP Screen Setup - Just the FileName Only No Extentsion */
  MainMenuScreen              = "MainMenu"
  FileMenuScreen              = "FileMenu"
  MessageMenuScreen           = "Message"
  OfflineMailMenuScreen       = "Off-Mail"
  OfflineMailConfigMenuScreen = "Off-Cfg"
  InterNetMenuScreen          = "InterNet"
  DoorMenuScreen              = "Door"
  LordMenuScreen              = "Lord"
  ChatMenuScreen              = "Chat"
  YourSettingsMenuScreen      = "EditUser"
  TimeBankMenuScreen          = "TimeBank"
  LogOffMenuScreen            = "Log-Off" 
  FastByeScreen               = "Close"  
  CommandHelpScreen           = "Commands" 

  MainMenuHelpScreen          = "MainHelp"
  FileMenuHelpScreen          = "FileHelp"
  OfflineMailHelpScreen       = "Off-Mail-Help"

/* End User Definable Variables */


/* Initialise all the static BBS variables. */
Call AdeptInitRexx


HasAnsi = 1
Call CHECKANSI


/*Ĵ MAIN MENU */
MainMenu:

  Menu = "Main"
  Call CheckAnsi
  
  Call AdeptLocation line, "Main Menu"
  Call AdeptSayGen line, "Main Menu"
  
  Call AdeptCls line
  Call AdeptMenuType line,51,MainMenuScreen || ".ASC",,""
  
  Call AdeptCurPos line, 22, 0
  Call AdeptPrint line,"   Current Time:            Time Remaining:           Messages Waiting:\r\n"
  Call AdeptSleep line,86
  
  Call AdeptCurPos line,24,1
  Call AdeptPrint line, "{FGChoose:"
  Call ShowData

  if(AdeptRequestsLogoff(line)==1) then signal Finished

  Call GetKey
  SELECT
    /* Always on All Menus */
    WHEN (key=70) | (key=102) /* F or f */
      THEN Signal FileMenu
    WHEN (key=77) | (key=109) /* M or m */
      THEN Signal MessageMenu
    WHEN (key=33)             /* ! */
      THEN Signal DoorMenu
    WHEN (key=126)            /* ~ */
      THEN Signal FastBye
    WHEN (key=85) | (key=117) /* U or u */
      THEN Signal YourSettingsMenu
    WHEN (key=71) | (key=103) /* G or g */
      THEN Signal LogOffMenu
    WHEN (key=89) | (key=121) /* Y or y */
      THEN Call AdeptMenuType line,48,,,0
    WHEN (key=87) | (key=119) /* W or w */
      THEN Call AdeptMenuType line,42,,,0

    /* Menus */
    WHEN (key=88) | (key=120)  /* X or x */
      THEN Signal SysOpMenuCheck
    WHEN (key=73) | (key=105)  /* I or i */
      THEN Signal InternetCheck
    WHEN (key=67) | (key=99)   /* C or c */
      THEN Signal ChatMenu
    WHEN (key=68) | (key=100)  /* D or d */
      THEN Signal DoorMenu

    /* Scripts and/or Menutypes */
    WHEN (key=84) | (key=116)  /* T or t */
      THEN Call AdeptChainRexx "AdRead.Srx",line
    WHEN (key=66) | (key=98)   /* B or b */
      THEN Call AdeptChainRexx "Bulletin-System.Srx",line
    WHEN (key=80) | (key=112)  /* P or p */
      THEN Call AdeptChainRexx "UserInfo.Cmd",line
    WHEN (key=65) | (key=97)   /* A or a */
      THEN Call AdeptChainRexx AutoPost,line
    WHEN (key=86) | (key=118)  /* V or v */
      THEN Call AdeptChainRexxNc VoteBooth,line
    WHEN (key=63)              /* ? */
      THEN Call AdeptShow line,1,2, MainMenuHelpScreen || ".ASC",""
    OTHERWISE
      Call NOTACMD
  End
Signal MainMenu /* End MAIN Menu */
/**/



/*Ĵ SYSOP MENU */
SysOpMenu:  

  Call CheckAnsi

  Call AdeptLocation line, "System"
  Call AdeptSayGen line, "System"

  Call AdeptCls line
  Call AdeptPrint line,"1> Testing 1\r\n"
  Call AdeptPrint line,"2> Testing 2\r\n"
  Call AdeptPrint line,"3> Testing 3\r\n"
  Call AdeptPrint line,"4> Testing 4\r\n"
  Call AdeptPrint line,"5> Testing 5\r\n"
  Call AdeptPrint line,"D> Download Any File\r\n"
  Call AdeptPrint line,"S> Shell to OS/2\r\n"
  Call AdeptPrint line,"!> Shutdown AdeptXBBS\r\n"
  Call AdeptPrint line,"\r\n(X=Exit)\r\n"

  Call AdeptSleep line,86
  Call AdeptCurPos line,24,1
  Call AdeptPrint line, "{FGChoose:"

  if(AdeptRequestsLogoff(line)==1) then signal Finished

  Call GetKey
  SELECT
    WHEN (key=49)
      THEN Call AdeptChainRexxNc "testing1.cmd",line
    WHEN (key=50)
      THEN Call AdeptChainRexxNc "testing2.cmd",line
    WHEN (key=51)
      THEN Call AdeptChainRexxNc "testing3.cmd",line
    WHEN (key=52)
      THEN Call AdeptChainRexxNc "testing4.cmd",line
    WHEN (key=53)
      THEN Call AdeptChainRexxNc "testing5.cmd",line
    WHEN (key=88) | (key=120)  /* X or x */
      THEN Signal MainMenu
    WHEN (key=68) | (key=100)  /* D or d */
      THEN Signal DLAnyFileMenu
    WHEN key=33    /* ! */
      THEN Call AdeptMenuType line,950,,,
    OTHERWISE
      Call NOTACMD
  End
Signal SysOpMenu /* End SYSOP Menu */
/**/



/*Ĵ SYSOP CHECK MENU */
SysOpMenuCheck:

  Call CheckAnsi

  SecLevel1 = AdeptGetVar(line,40) /* Grab Security Levels To verify */
  SecLevel2 = AdeptGetVar(line,41)

  If SecLevel1 >= SysOpMenuSecurityLevel1 Then /* Compare it to Sec1 */
    If SecLevel2 >= SysOpMenuSecurityLevel2 Then /* Compare it to Sec2 */
    Do /* Both Security Levels were high enough now test for the Password */
      Call AdeptLocation line, "System"
      Call AdeptSayGen line, "System"
      Call AdeptCls line
      Call AdeptSleep line,86
      Call AdeptLog line,3,"Security Level 1&2 Verified!"

      SysOpPasswordCheck = AdeptInput(line,1,50,,STRF_REQUIRED,"{FBPassword : {F8",,,)

      If SysOpPasswordCheck == SysOpPassword
      Then
      Do
        Call AdeptLog line,3,"Security Password Verified!"
        Signal SysOpMenu
      End
      else
      Do
        Call AdeptLog line,3,"Security Password FAILED!"
        Signal MainMenu
      End
    End
    else /* Sec2 wasn't high enough */
      Call AdeptLog line, 3,"User Failed Security Level 2 Check"
  else /* Sec1 wasn't high enough */
  Do /* They didn't have the security so lets fake them out and make them think they hit an undefined key */
    Call AdeptLog line,3,"User failed Security Level 1 Check"
    Call AdeptShow line,1,2,COMMANDS.ASC,""
    Signal MainMenu
  End
Signal MainMenu 
/**/



/*Ĵ MESSAGE MENU */
MessageMenu:

  Menu = "Message"

  Call CheckAnsi
  Call AdeptLocation line, "Message Menu"
  Call AdeptSayGen line, "Message Menu"

  Call AdeptCls line
  Call AdeptShow line,1,2,MessageMenuScreen || ".ASC",""

  Call AdeptCurPos line, 22, 0
  Call AdeptPrint line,"   Current Time:            Time Remaining:           Messages Waiting:\r\n"
  Call AdeptSleep line,86

  Call AdeptCurPos line,24,1
  Call AdeptPrint line, "{FGChoose:"
  Call SHOWDATA

  if(AdeptRequestsLogoff(line)==1) then signal Finished    


  Call GetKey
  SELECT
    /* Always on All Menus */
    WHEN (key=70) | (key=102) /* F or f */
      THEN Signal FileMenu
    WHEN (key=77) | (key=109) /* M or m */
      THEN Signal MessageMenu
    WHEN (key=33)             /* ! */
      THEN Signal DoorMenu
    WHEN (key=126)            /* ~ */
      THEN Signal FastBye
    WHEN (key=85) | (key=117) /* U or u */
      THEN Signal YourSettingsMenu
    WHEN (key=66) | (key=98)  /* B or b */
      THEN Signal LogOffMenu
    WHEN (key=89) | (key=121) /* Y or y */
      THEN Call AdeptMenuType line,48,,,0 /* Yell */
    WHEN (key=87) | (key=119) /* W or w */
      THEN Call AdeptMenuType line,42,,,0 /* Who's Online */


    WHEN key=62               /* > */
      THEN AdeptMessage(line,5,,"")  /* Goto next area */
    WHEN key=60               /* < */
      THEN AdeptMessage(line,6,,"")  /* Goto previous area */
    WHEN (key=82) | (key=114) /* R or r */
      THEN Call AdeptMenuType line,20
    WHEN (key=71) | (key=103) /* G or g */
      THEN Call AdeptChainRexx "D:\adept\aman\amanG.erx",line
    WHEN (key=65) | (key=97)  /* A or a */
      THEN Call AdeptChainRexx "D:\adept\aman\amanA.erx",line
    WHEN (key=68) | (key=100) /* D or d */
      THEN Call AdeptMenuType line,60 /* Default Change */
    WHEN (key=69) | (key=101) /* E or e */
      THEN Call AdeptWrite line,1,,"" /* Enter a msg */
    WHEN (key=67) | (key=99)  /* C or c */
      THEN Call Comment2Sysop
    WHEN (key=79) | (key=111) /* O or o */
      THEN Signal OfflineMailMenu /* goto offline */
    WHEN (key=78) | (key=110) /* N or n */
      THEN Call AdeptMenuType line,15,"" /* New mail read */
    WHEN (key=81) | (key=113) /* Q or q */
      THEN Call AdeptMenuType line,16,,"" /* Quickscan messages */
    WHEN (key=83) | (key=115) /* S or s */
      THEN Call AdeptMenuType line,17,,"" /* Detailed Scan */
    WHEN (key=80) | (key=112) /* P or p */
      THEN Call AdeptMenuType line,900,"" /* Your Mailbox */
    WHEN (key=88) | (key=120) /* X or x */
      THEN Call AdeptMenuType line, 28,,"" /* Search Messages */
    WHEN (key=84) | (key=116) /* T or t */
      THEN Signal MainMenu
    WHEN key=45               /* - */
      THEN Signal MainMenu
    WHEN key=63               /* ? */
      THEN Call AdeptShow line,1,2,CommandHelpScreen || ".ASC",""
    OTHERWISE
      Call NOTACMD
  End
Signal MessageMenu
/**/



/*Ĵ FILE MENU */
FileMenu:

  Menu = 'File'

  Call CheckAnsi
  Call AdeptLocation line, "File Menu"
  Call AdeptSayGen line, "File Menu"

  Call AdeptCls line
  Call AdeptShow line,1,2,FileMenuScreen || ".ASC",""

  Call AdeptCurPos line, 22, 0
  Call AdeptPrint line,"   Current Time:            Time Remaining:           Messages Waiting:\r\n"
  Call AdeptSleep line,86

  Call AdeptCurPos line,24,1
  Call AdeptPrint line, "{FGChoose:"
  Call SHOWDATA

  if(AdeptRequestsLogoff(line)==1) then signal Finished


  Call GetKey
  SELECT
  /* Always on All Menus */
    WHEN (key=70) | (key=102) /* F or f */
      THEN Signal FileMenu
    WHEN (key=77) | (key=109) /* M or m */
      THEN Signal MessageMenu
    WHEN (key=33)             /* ! */
      THEN Signal DoorMenu
    WHEN (key=126)            /* ~ */
      THEN Signal FastBye
    WHEN (key=66) | (key=98)  /* B or b */
      THEN Signal LogOffMenu
    WHEN (key=89) | (key=121) /* Y or y */
      THEN Call AdeptMenuType line,48,,,0 /* Yell */
    WHEN (key=87) | (key=119) /* W or w */
      THEN Call AdeptMenuType line,42,,,0 /* Who's Online */


    WHEN (key=76) | (key=108) /* L or l */
      THEN Call AdeptMenuType line,78,""    /* List files in area */
    WHEN (key=71) | (key=103) /* G or g */
      THEN Call AdeptChainRexx "D:\adept\afan\afanG.erx",line /* Change Group */
    WHEN (key=65) | (key=97)  /* A or a */
      THEN Call AdeptChainRexx "D:/adept/afan/afana.erx",line /* Change Area */
    WHEN (key=69) | (key=101) /* E or e */
      THEN Call AdeptMenuType line, 670,,"" /* Edit files List */
    WHEN (key=85) | (key=117) /* U or u */
      THEN Call AdeptMenuType line,90,""    /* Upload a file */
    WHEN (key=68) | (key=100) /* D or d */
      THEN Call AdeptMenuType line,85,""    /* Download */
    WHEN (key=83) | (key=115) /* S or s */
      THEN Call AdeptMenuType line,76,""    /* KeyWord Search */
    WHEN (key=80) | (key=112) /* P or p */
      THEN Call AdeptMenuType line,146,""   /* Select Default Protocol */
    WHEN (key=86) | (key=118) /* V or v */
      THEN Call AdeptMenuType line,84,,""   /* view an archive */
    WHEN key=61               /* = */
      THEN Call AdeptMenuType line,61       /* Default Listing */
    WHEN (key=78) | (key=110) /* N or n */
      THEN Call AdeptMenuType line,74,""    /* New files */
    WHEN key=62               /* > */
      THEN Call AdeptFile line,5,,""        /* Goto next area */
    WHEN key=60               /* < */
      THEN Call AdeptFile line,6,,""        /* Goto previous area */
    WHEN (key=67) | (key=99)  /* C or c */
      THEN Call Comment2Sysop
    WHEN (key=42)             /* * */
      THEN Call AdeptSend line,,,"D:/files/essentia/filelist.zip" /* Newfiles List */
    WHEN (key=84) | (key=116) /* T or t */
      THEN Signal MainMenu
    WHEN (key=45)             /* - */
      THEN Signal MainMenu
    WHEN (key=63)             /* ? */
      THEN Call AdeptShow line,1,2,FileMenuHelpScreen || ".ASC",""
    OTHERWISE
      Call NOTACMD
  END
Signal FileMenu
/**/



/*Ĵ DOOR MENU */
DoorMenu:

  Menu = 'Door'

  Call DoorMenuCheck
  Call CheckAnsi
  Call AdeptLocation line, "Door Menu"
  Call AdeptSayGen line, "Door Menu"

  Call AdeptCls line
  Call AdeptShow line,1,2,DoorMenuScreen || ".ASC",""

  Call AdeptCurPos line, 22, 0
  Call AdeptPrint line,"   Current Time:            Time Remaining:           Messages Waiting:\r\n"
  Call AdeptSleep line,86

  Call AdeptCurPos line,24,1
  Call AdeptPrint line, "{FGChoose:"
  Call SHOWDATA

  if(AdeptRequestsLogoff(line)==1) then signal Finished


  Call GetKey
  SELECT
  /* Always on All Menus */
    WHEN (key=70) | (key=102) /* F or f */
      THEN Signal FileMenu
    WHEN (key=77) | (key=109) /* M or m */
      THEN Signal MessageMenu
    WHEN (key=33)             /* ! */
      THEN Signal DoorMenu
    WHEN (key=126)            /* ~ */
      THEN Signal FastBye
    WHEN (key=85) | (key=117) /* U or u */
      THEN Signal YourSettingsMenu
    WHEN (key=66) | (key=98)  /* B or b */
      THEN Signal LogOffMenu
    WHEN (key=71) | (key=103) /* G or g */
      THEN Signal LogOffMenu
    WHEN (key=84) | (key=116) /* T or t */
      THEN Signal MainMenu
    WHEN (key=89) | (key=121) /* Y or y */
      THEN Call AdeptMenuType line,48,,,0 /* Yell */
    WHEN (key=87) | (key=119) /* W or w */
      THEN Call AdeptMenuType line,42,,,0 /* Who's Online */
    WHEN (key=67) | (key=99)  /* C or c */
      THEN Call Comment2Sysop

    WHEN key=49
    THEN DO
      Call AdeptPrint line,"{CS{F4Relax, I'm looking for the {F5Dragon{F4.."
      Call AdeptLocation line, "Legend of the Red Dragon"
      Call AdeptSayGen line, "Legend of the Red Dragon"
      Call UpdateDoorStats "LORD"
      Call AdeptMenuType line,801,"RunBBSDoors.exe {LN D:\\ADEPT\\Batches\\Lord.Bat " || line
    END
    WHEN key=50
    THEN DO
      Call AdeptPrint line,"{CS{F4Please Wait... Loading Operation Overkill..."
      Call AdeptLocation line, "Operation Overkill II"
      Call AdeptSayGen line, "Operation Overkill II"
      Call UpdateDoorStats "OOII"
      Call AdeptMenuType line,801,"RunBBSDoors.exe {LN D:\\ADEPT\\Batches\\oo.Bat " || line
    END
    WHEN key=51
    THEN DO
      Call AdeptPrint line,"{CS{F2Prepare yourself for BarneySplat!..."
      Call AdeptLocation line, "BarneySplat!"
      Call AdeptSayGen line, "BarneySplat!"
      Call UpdateDoorStats "barney"
      Call AdeptMenuType line,801,"RunBBSDoors.exe {LN D:\\ADEPT\\Batches\\barney.Bat " || line
    END
    WHEN key=52
    THEN DO
      Call AdeptPrint line,"{CS{F2Entering LORE..."
      Call AdeptLocation line, "LORE"
      Call AdeptSayGen line, "LORE"
      Call UpdateDoorStats "LORE"
      Call AdeptMenuType line,801,"RunBBSDoors.exe {LN D:\\ADEPT\\Batches\\lore.bat " || line
    END
    WHEN key=53
    THEN DO
      Call AdeptPrint line,"{CS{F4Entering the Land of Arrowbridge"
      Call AdeptLocation line, "Arrowbridge"
      Call AdeptSayGen line, "Arrowbridge"
      Call UpdateDoorStats "ABridge"
      Call AdeptMenuType line,801,"RunBBSDoors.exe {LN D:\\ADEPT\\Batches\\abridge.Bat " || line
    END
    WHEN key=54
    THEN DO
      Call AdeptPrint line,"{CS{FEPlanets: The Exploration Of Space..."
      Call AdeptLocation line, "Planets: TEOS"
      Call AdeptSayGen line, "Planets: TEOS"
      Call UpdateDoorStats "TEOS"
      Call AdeptMenuType line,801,"RunBBSDoors.exe {LN D:\\ADEPT\\Batches\\teos.Bat " || line
    END
    WHEN key=55
    THEN DO
      Call AdeptPrint line,"{CS{FEPrepare for Barren Realms Elite..."
      Call AdeptLocation line, "Barren Realms Elite"
      Call AdeptSayGen line, "Barren Realms Elite"
      If(AdeptChainREXXNc("bre777.cmd",line)=1)then
        Call UpdateDoorStats "BRE"
    END
    WHEN key=56
    THEN DO
      Call AdeptPrint line,"{CS{F4Strap on your Straight Jacket and enter Lunatix..."
      Call AdeptLocation line, "Lunatix"
      Call AdeptSayGen line, "Lunatix"
      Call UpdateDoorStats "Lunatix"
      Call AdeptMenuType line,801,"RunBBSDoors.exe {LN D:\\ADEPT\\Batches\\lunatix.Bat " || line
    END
    WHEN key=45
      THEN Signal MainMenu
    WHEN (key=63)  /* =? */
      THEN Call AdeptShow line,1,2,CommandHelpScreen || ".ASC",""
    OTHERWISE
      Call NOTACMD
  END
Signal DoorMenu
/**/



/*Ĵ DOOR MENU CHECK */
DoorMenuCheck:

  menu = 'DoorMenuCheck'

  Call CheckAnsi
  Call AdeptSleep line,86

  Call AdeptLocation line, "DoorMenuCheck"
  Call AdeptSayGen line, "DoorMenuCheck"

  If(DoorsDisabled=='TRUE')Then
  do
    Call AdeptPrint line, "\r\nSorry The Door menu is temporary unavailable.\r\n"
    Call AdeptPrint line, "Please Try Again Later.\r\n"
	Call AdeptPrint line, "{PB"
	Signal MainMenu
  end

  ComPortName = AdeptGetVar(line,202)

  if((LEFT(ComPortName,3)\='COM') | ((LEFT(ComPortName,3)='COM') & (RIGHT(ComPortName,1)<1))) /* Must NOT be telnet or npipe */
  Then Do
    Call AdeptPrint line, "\r\nSorry the DoorMenu can only be accessed by"
    Call AdeptPrint line, "\r\ndial up or VModem nodes\r\n"
    Call AdeptPrint line, "{PB"
    Signal MainMenu /* Sorry named pipes and internal telnet lines == NO GAMES */
  End
  else /* Valid Port number or a VModem node == GAMES! */
    return
/**/



/*Ĵ YOUR SETTINGS MENU */
YourSettingsMenu:

  menu = 'YourSettings'
  Call CheckAnsi
  Call AdeptLocation line, "User Settings"
  Call AdeptSayGen line, "Your Settings"
  Call AdeptShow line,1,2,YourSettingsMenuScreen || ".ASC",""
  Call AdeptSleep line,86

  if(AdeptRequestsLogoff(line)==1) then signal Finished

  Call GetKey
  SELECT
  /* Always on All Menus */
    WHEN (key=70) | (key=102) /* F or f */
      THEN Signal FileMenu
    WHEN (key=77) | (key=109) /* M or m */
      THEN Signal MessageMenu
    WHEN (key=33)             /* ! */
      THEN Signal DoorMenu
    WHEN (key=126)            /* ~ */
      THEN Signal FastBye
    WHEN (key=85) | (key=117) /* U or u */
      THEN Signal YourSettingsMenu
    WHEN (key=84) | (key=116) /* T or t */
      THEN Signal MainMenu
    WHEN (key=89) | (key=121) /* Y or y */
      THEN Call AdeptMenuType line,48,,,0 /* Yell */
    WHEN (key=87) | (key=119) /* W or w */
      THEN Call AdeptMenuType line,42,,,0 /* Who's Online */

    WHEN key=48               /* 0 */
      THEN Call AdeptMenuType line,135,""   /* More prompts */
    WHEN key=49               /* 1 */
      THEN Call AdeptMenuType line,136,""   /* Name/Handle */
    WHEN key=50               /* 2 */
      THEN Call AdeptMenuType line,130, ""  /* City */
    WHEN key=51               /* 3 */
      THEN Call AdeptMenuType line,139, ""  /* Phone number */
    WHEN key=52               /* 4 */
      THEN Call AdeptMenuType line,139, ""  /* Phone number */
    WHEN key=53               /* 5 */
      THEN Call AdeptMenuType line,137, ""  /* Password */
    WHEN key=54               /* 6 */
      THEN Call AdeptMenuType line,146, ""  /* Xtern Protocol */
    WHEN key=55               /* 7 */
      THEN Call AdeptMenuType line,703,""   /* Mail type */
    WHEN key=56               /* 8 */
      THEN Call AdeptMenuType line,166,""   /* Default archiver */
    WHEN key=57               /* 9 */
      THEN Call AdeptMenuType line,157,""   /* Clear screen */
    WHEN (key=65) | (key=97)  /* A or a */
      THEN Call AdeptMenuType line,138,""   /* Screen Width */
    WHEN (key=66) | (key=98)  /* B or b */
      THEN Call AdeptMenuType line,134,""   /* Screen Length */
    WHEN (key=67) | (key=99)  /* C or c */
      THEN Call AdeptMenuType line,154,""   /* Full screen Editor */
    WHEN (key=68) | (key=100) /* D or d */
      THEN Call AdeptMenuType line,131,""   /* ANSI */
    WHEN (key=69) | (key=101) /* E or e */
      THEN Call AdeptMenuType line,623,""   /* ANSI */
    WHEN (key=71) | (key=103) /* G or g */
      THEN Call AdeptMenuType line,165,""   /* Offline mail */
    WHEN (key=88) | (key=120) | (key=27)    /* X or x or [ESC] */
      THEN Signal MainMenu                  /* Quit Editing */
    WHEN (key=63)              /* ? */
      THEN Call AdeptShow line,1,2,CommandHelpScreen || ".ASC",""
    WHEN (key=45)              /* - */
      THEN Signal MainMenu
    OTHERWISE
      Call NOTACMD
  END

Signal YourSettingsMenu
/**/



/*Ĵ OFFLINE MAIL MENU */
OfflineMailMenu:

  Menu = "OfflineMail"

  Call CheckAnsi
  Call AdeptLocation line, "Offline Mail"
  Call AdeptSayGen line, "Offline Mail"

  Call AdeptCls line
  Call AdeptShow line,1,2,OfflineMailMenuScreen || ".ASC",""

  Call AdeptCurPos line, 22, 0
  Call AdeptPrint line,"   Current Time:            Time Remaining:           Messages Waiting:\r\n"
  Call AdeptSleep line,86

  Call AdeptCurPos line,24,1
  Call AdeptPrint line, "{FGChoose:"
  Call SHOWDATA

  if(AdeptRequestsLogoff(line)==1) then signal Finished


  Call GetKey
  SELECT
  /* Always on All Menus */
    WHEN (key=70) | (key=102)  /* F or f */
      THEN Signal FileMenu
    WHEN (key=33)              /* ! */
      THEN Signal DoorMenu
    WHEN (key=126)             /* ~ */
      THEN Signal FastBye
    WHEN (key=66) | (key=98)   /* B or b */
      THEN Signal LogOffMenu
    WHEN (key=71) | (key=103)  /* G or g */
      THEN Signal LogOffMenu
    WHEN (key=89) | (key=121)  /* Y or y */
      THEN Call AdeptMenuType line,48,,,0 /* Yell */
    WHEN (key=87) | (key=119)  /* W or w */
      THEN Call AdeptMenuType line,42,,,0 /* Who's Online */
    WHEN (key=67) | (key=99)   /* C or c */
      THEN Call Comment2Sysop

    WHEN (key=65) | (key=97)   /* A or a */
      THEN Call AdeptMenuType line,166,"" /* Arc Type */
    WHEN (key=83) | (key=115)  /* S or S */
      THEN Call AdeptMenuType line,703,"" /* Pkt Type */
    WHEN (key=80) | (key=112)  /* P or p */
      THEN Call AdeptMenuType line,146,"" /* Protocol */
    WHEN (key=77) | (key=109)  /* M or m */
      THEN Call AdeptMenuType line,632,"" /* Monitor */
    WHEN (key=76) | (key=108)  /* L or l */
      THEN Call AdeptMenuType line,704,"" /* LMR Edit */
    WHEN (key=84) | (key=116)  /* T or t */
      THEN Call AdeptMenuType line,702,"" /* tag areas */
    WHEN (key=68) | (key=100)  /* D or d */
      THEN Call AdeptMenuType line,35,""  /* Download mail */
    WHEN (key=85) | (key=117)  /* U or u */
      THEN Call AdeptMenuType line,36,""  /* Upload mail */
    WHEN key=45                /* - */
      THEN Signal MessageMenu
    WHEN key=63                /* ? */
      THEN Call AdeptShow line,1,2,OfflineMailHelpScreen || ".ASC",""
    OTHERWISE
      Call NOTACMD
  END

Signal OfflineMailMenu /* End OFFLINEMAIL Menu */
/**/



/*Ĵ INTERNET MENU */
InterNetMenu:

  Menu = "InterNet"

  Call CheckAnsi
  Call AdeptLocation line, "InterNet Menu"
  Call AdeptSayGen line, "InterNet Menu"

  Call AdeptCls line
  Call AdeptShow line,1,2,InterNetMenuScreen || ".ASC",""

  Call AdeptCurPos line, 22, 0
  Call AdeptPrint line,"   Current Time:            Time Remaining:           Messages Waiting:\r\n"
  Call AdeptSleep line,86

  Call AdeptCurPos line,24,1
  Call AdeptPrint line, "{FGChoose:"
  Call SHOWDATA

  if(AdeptRequestsLogoff(line)==1) then signal Finished

  Call GetKey
  SELECT
  /* Always on All Menus */
    WHEN (key=33)              /* ! */
      THEN Signal DoorMenu
    WHEN (key=126)             /* ~ */
      THEN Signal FastBye
    WHEN (key=66) | (key=98)   /* B or b */
      THEN Signal LogOffMenu
    WHEN (key=89) | (key=121)  /* Y or y */
      THEN Call AdeptMenuType line,48,,,0 /* Yell */
    WHEN (key=67) | (key=99)   /* C or c */
      THEN Call Comment2Sysop
    WHEN (key=84) | (key=116)  /* T or t */
      THEN DO
        tttid=AdeptStartREXXThread("telnettimer.cmd",line)
        Call AdeptChainRexxNC "D:\adept\menus\telnetsnoop.cmd",line
        AdeptKillREXXThread(tttid)
      end
    WHEN (key=73) | (key=105)  /* I or i */
      THEN DO
        tttid=AdeptStartREXXThread("telnettimer.cmd",line)
        Call AdeptChainRexxNC "D:\adeptIRC\AdeptIRC.srx",line
        AdeptKillREXXThread(tttid)
      end
    WHEN (key=70) | (key=102)  /* F or f */
      THEN DO
        tttid=AdeptStartREXXThread("telnettimer.cmd",line)
        Call AdeptChainRexxNC "D:\adept\menus\ftp.cmd",line
        AdeptKillREXXThread(tttid)
      end
    WHEN (key=71) | (key=103)  /* G or g */
      THEN DO
        tttid=AdeptStartREXXThread("telnettimer.cmd",line)
        Call AdeptChainRexxNC "D:\adept\menus\gopher.cmd",line
        AdeptKillREXXThread(tttid)
      end
    WHEN (key=87) | (key=119)  /* W or w */
      THEN DO
        tttid=AdeptStartREXXThread("telnettimer.cmd",line)
        Call AdeptMenuType line,801,"cmd.exe /c D:\\adept\\menus\\www.cmd {H0"
        AdeptKillREXXThread(tttid)
      end
    WHEN key=63                /* ? */
      THEN Call AdeptShow line,1,2,CommandHelpScreen || ".ASC",""
    WHEN key=45                /* - */
      THEN Signal MainMenu
    OTHERWISE
      Call NOTACMD
  END

Signal InterNetMenu
/**/


/*Ĵ INTERNET CHECK MENU */
InterNetCheck:

  Call CheckAnsi

  Call AdeptSleep line,86
  Call AdeptLocation line, "InterNet Check"
  Call AdeptSayGen line, "InterNet Check"
  Call AdeptSleep line,86

  SecLevel1 = AdeptGetVar(line,40) /* Grab Security Levels To verify */
  SecLevel2 = AdeptGetVar(line,41)

  If SecLevel1 >= InternetSecurityLevel1 Then /* Compare it to Sec1 */
    If SecLevel2 >= InternetSecurityLevel2 Then /* Compare it to Sec2 */
    do /* Both Security Levels were high enough now lets test for the Passoword */
      Call AdeptLocation line, "System"
      Call AdeptSayGen line, "System"
      Call AdeptCls line
      Call AdeptSleep line,86
      Call AdeptLog line,3,"Security Level 1&2 Verified!"
    end
    else /* Sec2 wasn't high enough */
    do
      Call AdeptPrint line, "{CS\r\n\r\nI'm sorry, You must be verified before you access the Internet.\r\n"
      Call AdeptPrint line, "Send the Sysop a message with the Subject Verify Me!\r\n{PC"
      Signal MainMenu
    end
  else /* Sec1 wasn't high enough */
  do /* They didn't have the security so tell them to send us a comment! */
    Call AdeptPrint line, "{CS\r\n\r\nI'm sorry, You must be verified before you access the Internet.\r\n"
    Call AdeptPrint line, "Would you like to send the Sysop a Message [Y/n]? "
    Call GetKey
    If(D2C(key)=='N')|(D2C(key)=='n')then
      Signal MainMenu
    else
    do
      Call Comment2Sysop
      Signal MainMenu
    end
  end

  IsTCPIPAlive = Stream(TCPIPFlag,'c','query exists')
  If IsTCPIPAlive = "" Then
  Do
    Call AdeptSleep line,86
    Call AdeptLog line, 3, "**INTERNET Connection is down!"
    Call AdeptPrint line, "\r\nSorry...The InterNet Connection is down."
    Call AdeptPrint line, "\r\nPlease try again later."
    Call AdeptSleep line,86
    Call AdeptPrint line,"{PC"
    Call AdeptSleep line,86
    Signal MainMenu
  End

  Call AdeptCLS line
  Call AdeptPrint line, "\r\nWARNING: We cannot be responsible for the content of the information\r\n"
  Call AdeptPrint line, "         received via the Internet. By selecting any of the commands\r\n"
  Call AdeptPrint line, "         below you hereby relieve the SysOp of any neglegence,\r\n"
  Call AdeptPrint line, "         or wrong doing. Please remember you are entering a domain\r\n"
  Call AdeptPrint line, "         that we have no control over. \r\n"
  Call AdeptPrint line, "{PB"

Signal InterNetMenu
/**/



/*Ĵ CHAT MENU */
ChatMenu:

  Menu = "Chat"

  Call CheckAnsi
  Call AdeptLocation line, "Chat Menu"
  Call AdeptSayGen line, "Chat Menu"

  Call AdeptCls line
  Call AdeptShow line,1,2,ChatMenuScreen || ".ASC",""

  Call AdeptCurPos line, 22, 0
  Call AdeptPrint line,"   Current Time:            Time Remaining:           Messages Waiting:\r\n"
  Call AdeptSleep line,86

  Call AdeptCurPos line,24,1
  Call AdeptPrint line, "{FGChoose:"
  Call SHOWDATA

  if(AdeptRequestsLogoff(line)==1) then signal Finished


  Call GetKey
  SELECT
  /* Always on All Menus */
    WHEN (key=70) | (key=102) /* F or f */
      THEN Signal FileMenu
    WHEN (key=77) | (key=109) /* M or m */
      THEN Signal MessageMenu
    WHEN (key=33)             /* ! */
      THEN Signal DoorMenu
    WHEN (key=126)            /* ~ */
      THEN Signal FastBye
    WHEN (key=66) | (key=98)  /* B or b */
      THEN Signal LogOffMenu
    WHEN (key=85) | (key=117) /* U or u */
      THEN Signal YourSettingsMenu
    WHEN (key=71) | (key=103) /* G or g */
      THEN Signal LogOffMenu
    WHEN (key=84) | (key=116) /* T or t */
      THEN Signal MainMenu
    WHEN (key=89) | (key=121) /* Y or y */
      THEN Call AdeptMenuType line,48,,,0 /* Yell */
    WHEN (key=67) | (key=99)  /* C or c */
      THEN Call Comment2Sysop

  /* This Menu Specific */
    WHEN (key=87) | (key=119) /* W or w */
      THEN Call AdeptMenuType line,42,,,0 /* Who's Online */
    WHEN (key=74) | (key=106) /* J or j */
      THEN Call AdeptChainREXXNc "chat.cmd",line
    WHEN (key=65) | (key=97)  /* A or a */
      THEN Call AdeptMenuType line,623,,0 /* Toggle avail for chat */
    WHEN key=63               /* ? */
      THEN Call AdeptShow line,1,2,OfflineMailHelpScreen || ".ASC",""
    OTHERWISE
      Call NOTACMD
  END

Signal ChatMenu /* End CHAT Menu */
/**/



/*Ĵ LOGOFF MENU */
LogOffMenu:

  Call CheckAnsi
  Call AdeptLocation line, "LogOff Menu"
  Call AdeptSayGen line, "LogOff Menu"
  
  Call AdeptShow line,1,2,LogOffMenuScreen || ".ASC",""
  Call AdeptSleep line,86
  Call AdeptCurPos line,24,1
  Call AdeptPrint line,"{FGChoose:"

  if(AdeptRequestsLogoff(line)==1) then signal Finished
  
  Call GetKey

  SELECT
    WHEN (key=89) | (key=121) | (key=13)  /* =Y or y or [ENTER]*/
    THEN DO
      Call AdeptShow line,1,2,Goodbye.ASC,""
      Call AdeptSleep line,86
      Call Fastbye
    END
    WHEN (key=78) | (key=110) /* N or n */
    THEN DO
      if Menu == "Main"         Then Signal MainMenu
      if Menu == "Door"         Then Signal DoorMenu
      if Menu == "File"         Then Signal FileMenu
      if Menu == "Message"      Then Signal MessageMenu
      if Menu == "OfflineMail"  Then Signal OfflineMailMenu
      if Menu == "TimeBank"     Then Signal TimeBankMenu
      if Menu == "YourSettings" Then Signal YourSettingsMenu
      if Menu == "Lord"         Then Signal LordMenu
      if Menu == "Chat"         Then Signal ChatMenu
      if Menu == "InterNet"     Then Signal InternetMenu
      OTHERWISE Signal MainMenu
    End
    WHEN (key=67) | (key=99)  /* C or c */
      THEN Call Comment2Sysop
    WHEN (key=63)             /* ? */
      THEN Call AdeptShow line,1,2,CommandHelpScreen || ".ASC",""
    OTHERWISE
      Call NOTACMD
  END

Signal LogOffMenu
/**/



/*Ĵ FASTBYE */
Fastbye:

  Call CheckAnsi

  Call AdeptLocation line, "Disconnecting"
  Call AdeptSayGen line, "Disconnecting"

  Do 10
    Call AdeptPrint line,"{PA."
    Call AdeptSleep line,64
  End
  Call AdeptPrint line,"{F9Click!"
  Call AdeptShow line,1,2,FastByeScreen || ".Asc",""
  Call AdeptMenuType line,1001,""

Signal Finished 
/**/



/*Ĵ GETKEY */
GetKey:

  Do Forever
    if(AdeptSysChatMsgWaiting(line) == 1)then
      call HandleChat

    Call AdeptSleep line,128
    Key = AdeptTimedInkey(line, 30000)
    Call AdeptSleep line,128
  
    if(AdeptRequestsLogoff(line)==1) then signal Finished

    SELECT
      WHEN (key="0")
        THEN Do
          Call AdeptSleep line,128
          Call ShowData
          Call AdeptSleep line,128
        End
      WHEN (key=TIMEOUT)
        THEN Do
          Call AdeptSleep line,128
          Call ShowData
          Call AdeptSleep line,128
        End
      WHEN (key=LOSTCARRIER)       /* Carrier Loss */
        THEN Do
          Call AdeptSleep line,128
          signal Finished 
          Call AdeptSleep line,128
        End
      WHEN (key=IRC_NOTIMELEFT)    /* SysOp F3 (HangUp) */
        THEN Do
          Call AdeptSleep line,128
          signal Finished 
          Call AdeptSleep line,128
        End
      WHEN (key=IRC_LOCKEDOUT)     /* SysOp F4 (LockOut) */
        THEN Do
          Call AdeptSleep line,128
          signal Finished 
          Call AdeptSleep line,128
        End
      WHEN (key=IRC_MORON)         /* SysOp F5 (Moron) */
        THEN Do
          Call AdeptSleep line,128
          signal Finished 
          Call AdeptSleep line,128
        End
      WHEN (key=IRC_NOTIMELEFT)    /* No Time Left */
        THEN Do
          Call AdeptSleep line,128
          signal Finished 
          Call AdeptSleep line,128
        End
      WHEN (key=IRC_ENDSYSOPCHAT)  /* Exit a Sysop<>User Chat */
        THEN Do
          Call AdeptSleep line,128
          if Menu == "Main"         Then Signal MainMenu
          if Menu == "Door"         Then Signal DoorMenu
          if Menu == "File"         Then Signal FileMenu
          if Menu == "Message"      Then Signal MessageMenu
          if Menu == "OfflineMail"  Then Signal OfflineMailMenu
          if Menu == "TimeBank"     Then Signal TimeBankMenu
          if Menu == "YourSettings" Then Signal YourSettingsMenu
          if Menu == "Lord"         Then Signal LordMenu
          if Menu == "Chat"         Then Signal ChatMenu
          if Menu == "InterNet"     Then Signal InternetMenu
          OTHERWISE Signal MainMenu
          Call AdeptSleep line,128
        End
      WHEN (key=IRC_REPROMPT)      /* IRC_REPROMPT */
      THEN Do
        Call AdeptSleep line,128
        Call ShowData
        Call AdeptSleep line,128
      End
      WHEN (key=IRC_CHATWAITING)   /* Chat Message Waiting */
	  THEN Do
	    Call AdeptSleep line,128
		Call HandleChat
	    Call AdeptSleep line,128
	  End
      Otherwise
      Do
        Call AdeptSleep line,128
        return /* Cheap way out, but it works :> */
      End
    End /* end select */
  End /* end Do ForEver */

return /* Useless because it will never reach here...dead-code */
/**/



/*Ĵ SHOWDATA */
SHOWDATA:

  Call CheckAnsi

  if HasAnsi = 0 then return

  MyRet = AdeptTimerUp(line, DisplayTimer)

  if MyRet == 1 then
  do
    Call AdeptCurPos line,22,17
    Call AdeptPrint line,"{CR"

    Call AdeptCurPos line,22,44
    Call AdeptPrint line,"{T0"

    Call AdeptCurPos line,22,72
    Call AdeptPrint line,"{CX"

    TimeLeft=AdeptTimeLeft(line)/60
   
    If (TimeLeft <= 3) Then
    Do
      Call AdeptCurPos line,11,19
      Call AdeptPrint line,"{B8Ŀ"
      Call AdeptCurPos line,12,19
      Call AdeptPrint line,"{B8 {FGOnly two minutes remaining online!!!!! {B8"
      Call AdeptCurPos line,13,19
      Call AdeptPrint line,"{B8"
    End

    Call AdeptCurPos line,24,8 /* Reposition cursor infront of the Choice: Prompt */
  end

return
/**/



/*Ĵ CHECKANSI */
CHECKANSI:

  UserFlag = AdeptGetVar(line, 44)
  HasAnsi = AdeptCheckBit(line, 1, UserFlag)

return
/**/



/*Ĵ COMMENT2SYSOP */
COMMENT2SYSOP:

  Call AdeptPrint line,"{CS\r\n\r\nPlease enter the subject of your comment\n"
  Temp=AdeptMessage(line, 3, 1, "")  /* Comment to Sysop */
  Call AdeptSayGen line, "Writing Comment"
  Temp=AdeptWrite(line, 1, 3, "")

return
/**/



/*Ĵ HANDLECHAT */
HandleChat:

  RetC = AdeptSysChatGetMsg(line)

/* Debug
  call Adeptlog line,3,"RetC=="||Retc
  call Adeptlog line,3,"PktType=="||PktType
  call Adeptlog line,3,"ChatMsgFrom=="||CHATMSGFROM
  call Adeptlog line,3,"ChatMsgData=="||CHATMSGDATA
*/  

  if(RetC == 3) then do
    if(PktType == 102) then do
	  Call MsgBox ChatMsgData," Incoming Message "
    end
    if(PktType == 103) then do
	  Call MsgBox ChatMsgData," Incoming Message "
    end
    if(PktType == 105) Then do
	  Call MsgBox ChatMsgData," Incoming Message "
    end
  end

  Call AdeptSleep line,128
  if Menu == "Main"         Then Signal MainMenu
  if Menu == "Door"         Then Signal DoorMenu
  if Menu == "File"         Then Signal FileMenu
  if Menu == "Message"      Then Signal MessageMenu
  if Menu == "OfflineMail"  Then Signal OfflineMailMenu
  if Menu == "TimeBank"     Then Signal TimeBankMenu
  if Menu == "YourSettings" Then Signal YourSettingsMenu
  if Menu == "Lord"         Then Signal LordMenu
  if Menu == "Chat"         Then Signal ChatMenu
  if Menu == "InterNet"     Then Signal InternetMenu
  OTHERWISE Signal MainMenu
  Call AdeptSleep line,128

return
/**/



/*Ĵ UPDATEDOORSTATS */
UpdateDoorStats:

arg Door

 StatFile = "/adept/Stats/"||Door||"."||Date('S')

 Count = LineIn(StatFile)

 if(Count="")then
   Count=1
 else
   Count=Count+1

 Call Lineout Statfile, Count, 1
 Call Lineout StatFile

return
/**/



/*Ĵ DLANYFILE MENU */
DLAnyFileMenu:

 getfile = "d:\adept\system\line" || "{LN" || "\getfile"

 Call AdeptPrint line,"{CS\r\n"
 Call AdeptPrint line,"{FF  Get File   \r\n"
 Call AdeptPrint line,"{F8----------------------------------------\r\n"
 Call AdeptPrint line,"{FC 1. Download a File   \r\n"
 Call AdeptPrint line," 2. Quit Back To SysOp Menu  \r\n"
 Call AdeptPrint line,"{F8----------------------------------------\r\n"
 Call AdeptPrint line,"\r\n"

 option = AdeptInput(line,1,1,,,'{FBChoice : {F8',,,1)

 SELECT
   WHEN option = 1
     THEN DO
       option = AdeptInput(line,1,40,,,"\r\n{FBFileName [{F8include fullpath and filename{FB]\r\n")
       Call AdeptMenutype line,86,option
       Call AdeptPrint line,"\r\n"
       Call AdeptPrint line,"{PB"
       ADDRESS CMD "@del "||getfile||">nul"
     END
   WHEN option = 2
     THEN return
   OTHERWISE
     Signal DLAnyFileMenu
 END
return
/**/



/*Ĵ NOTACMD */
NOTACMD:

  rand = RANDOM(1,4) /* Generate a random number between 1 and 3. */

  if (key=13) Then
  Do
    Call AdeptPrint line,"\r\nAnd just what did you think you where entering?\r\n"
    return
   End

  SELECT
    WHEN rand = 1
      THEN Call AdeptPrint line, "\r\n{F4'{FF",D2C(KEY),"{F4' isn't a command!\r\n"
    WHEN rand = 2
      THEN Call AdeptPrint line, "\r\n{F4You hit '{FF",D2C(KEY),"{F4'. That's not an option!\r\n"
    WHEN rand = 3
      THEN Call AdeptShow line,1,2,CommandHelpScreen || ".ASC",""
    OTHERWISE
      Call AdeptPrint line, "\r\n{F4You hit '{FF",D2C(KEY),"{F4', which is not a valid option.\r\n"
  END

  Call AdeptSleep line,1000

Return
/**/



/*Ĵ AGDrawBox */
/* Usage:
     Call AGDrawBox width, height
*/
AGDrawBox:

  Arg width, height

  Left  = 40-TRUNC(width/2)
  Right = 40+TRUNC(width/2)
  Top   = TRUNC(ScreenLength/2-height/2)

  Call AdeptCurPos line, Top, Left
  Call Adeptprint line,""

  do width-2
    Call AdeptPrint line,""
  end

  Call AdeptPrint line,""

  do i = 1 to height
    Call AdeptCurPos line, top+i, left
    Call AdeptPrint line,""
    do width-2
      Call AdeptPrint line," "
    end
    Call AdeptPrint line,""
  end

  Call AdeptCurPos line, Top+height, Left
  Call Adeptprint line,""

  do width-2
    Call AdeptPrint line,""
  end

  Call AdeptPrint line,""

return
/**/



/*Ĵ MsgBox */
/* Usage:
     Call MsgBox "Text inside box", "Title" 
*/
MsgBox:
  
  Arg Output,Title

  TitleLength = LENGTH(Title)
  OutputLength = LENGTH(Output)

  i=0

  if(OutputLength>75)then
  do
    do while Length(Output)>1
      i=i+1

      ls = lastpos(' ',Output,76)
      if(ls==0) then
        OutputLength = 76
      else
        OutputLength = ls

      Out.i = Left(Output, OutputLength)
      if(Length(Output)>75)then
        Output = DbrLeft(Output, OutputLength)
      else
        Output = DbrLeft(Output, Length(Output))
    end
    OutputLength=76
  end
  else
  do
	i=1
    Out.i = Output
  end

  numlines = i

  if TitleLength>OutputLength then
  do
    TitleLength = OutputLength
    Title = Left(Title, TitleLength)
  end

  Call AGDrawBox Outputlength+4, 3+i

  Left = (40-TRUNC(Outputlength/2))
  Top = (TRUNC(ScreenLength/2)-TRUNC(i/2))
  Right = (40+TRUNC(OutputLength/2))

  Call AdeptCurPos line, Top, (40-TRUNC(Titlelength/2))
  Call AdeptPrint line,"{FG"||Title

  do a = 1 to numlines
    Call AdeptCurPos line, Top+1+a, (40-TRUNC(Outputlength/2))
    Call AdeptPrint line,Out.a
  end

  Call AdeptCurpos line, 24,0
  Call AdeptWaitKey line

return
/**/



/*Ĵ InputBox */
/* Usage:
     value = InputBox("Title")
*/
InputBox:

  Arg Title,MaxLength

  TitleLength = LENGTH(Title)
  Top = (TRUNC(ScreenLength/2)-3)

  /* Draw the Box */
  Call AGDrawBox MaxLength+4, 5

  /* Output the Title */
  Call AdeptCurPos line, Top, (40-TRUNC(Titlelength/2))
  Call AdeptPrint line,Title

  /* Read the input */
  Call AdeptCurPos line, Top+2, (40-TRUNC(MaxLength/2))
  szrc = AdeptInput(line, 1, MaxLength, STRT_ALL, STRF_EDIT+STRF_NOHELP, "", "", "", "")

return szrc
/**/



/*Ĵ Script Exit Point */
Error:
Halt:
Finished:
  exit
