/******************************************************************/
/*  Filename: cd_area2.cmd Autor: Torsten Schulz (2:249/1010.33)  */
/******************************************************************/
/*  Ziel: FileAreas fr Adept erstellen				  */
/*        Einlesen aller Verzeichnisse eines Pfads oder Laufwerks */
/*	  Vergleich mit der Beschreibung			  */
/*        Ausgabe der Areas in eine Datei                         */
/******************************************************************/
/*  Voraussetzung: Textdatei, das die Beschreibung enthlt        */
/*                 Name der Datei - dirs.txt                      */
/*			sollte im aktuellen Verzeichnis sein      */
/*                 nderung mglich -> filename ndern            */
/******************************************************************/
/*
    Eingabe: Laufwerk, Anfangsarea, Name der Area

    Ausgabe in "areas.cd" im aktuellen Pfad
*/

/* Fehlerbehandlung */
signal on failure
signal on halt
signal on syntax 

/* Laden von RexxUtil */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* Name der Textdatei, die die Beschreibung enthlt */
filename = 'dirs.txt'

/* Schablone fr eine Area von Adept */

T_beg = 'AREABEGIN'
T_nam = '  NAME   '
T_num = '  NUMBER '
T_des = '  DESC   '
T_dlp = '  DLPATH '
T_fla = '  FLAGS  '
T_end = 'AREAEND'

/* Hauptprogramm */

parse arg lw k Name_Verzeichnisse
if (lw = '') | (k = '') | (Name_Verzeichnisse = '')then 
	do
	  beep(800, 500)
	  say 'Fehler: Keine Angabe von Parameter' 
	  say ''
	  say 'Syntax: cd_area2 <Pfad> <Anfang> <Name>'
	  say ''
	  say '   Pfad -   Buchstabe fr Laufwerk (z.B. i:) oder'
	  say '              Pfadangabe (z.B. i:\test)'
	  say '   Anfang - Area, bei der begonnen werden soll'
	  say '              (z.B. 900, d.h. AreaNummer beginnt mit 900)'
	  say '   Name -   z.B. dir'
	  say '             dann heien die Areas dir1, dir2, usw.'
	  say '' 
	  say 'Programm wird abgebrochen!'
	  exit
	end
RC = SysFileTree(filename, egal, 'F')
if egal.0 = 0 then do
        beep(800, 500)
	say 'Fehler:' filename 'nicht gefunden. In aktuellen Pfad legen!'
	exit
end
Pfad = lw'\*.*'
aktuell = '!!!'
l = 1
say 'Suche nach Verzeichnissen. Bitte warten...'
RC = SysFileTree(Pfad, Ergebnis, 'SD') 
if Ergebnis.0 = 0 then do
        beep(800, 500)
	say 'Fehler:' 'Keine Verzeichnisse in' Pfad 'gefunden. Pfad prfen!'
	exit
end
say 'Es wurden ' Ergebnis.0 'Verzeichnisse gefunden:'
say ''
say 'Lese Beschreibungen (Datei: dirs.txt) und Vergleiche. Bitte warten...'
Nummer = 1
do while aktuell \= ''
	aktuell = LINEIN(filename)
	Zeile.Nummer = aktuell
	Nummer = Nummer + 1
end
Nummer = Nummer - 1
do i = 1 to Ergebnis.0
	zwi1 = SUBWORD(Ergebnis.i, 5)
	Verz = zwi1'\'
	do j = 1 to Nummer 
		zwi2 = SUBWORD(Zeile.j,1,1)
		zwi3 = TRANSLATE(zwi2)
		check = lw''zwi3
		if Verz = check then do
			Beschr = SUBWORD(Zeile.j,2)
			RC = LINEOUT('areas.cd',T_beg) 
			RC = LINEOUT('areas.cd',T_nam Name_Verzeichnisse''l) 
			RC = LINEOUT('areas.cd',T_num k) 
			RC = LINEOUT('areas.cd',T_des Beschr) 
			RC = LINEOUT('areas.cd',T_dlp Verz) 
			RC = LINEOUT('areas.cd',T_fla) 
			RC = LINEOUT('areas.cd',T_end) 
			k = k + 1
			l = l + 1
			say l Verz Beschr
		end
	end
end
exit