/* fixup.cmd - A files.bbs preprocessor for bfsmake4.exe */

CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs

if ARG() >< 0 then
  do
     parse ARG path startLine areas
     j = 0
     do while areas \= ""
        j = j + 1
        parse var areas area.j areas
     end
     area.0 = j
  end
else
  do  SAY "FIXUP.CMD: Makes bfsmake4 compatible area_num,bbs"
  say "USAGE:  fixup path start_line area_num [area_num ...]"
  say ""
  say "Input a file.bbs in <file_name> <size> <date> <description> format."
  say "Output is a area_num.bbs in <file_name> <description> format."
  say "Original file copied to area_num.old"
  say "path should not have a trailing '\'"
  say "start_line is the line of the input file with the first file listing"
  say ""
  say "Freely distribute - (c) 1995 - Doug Kushner"
  exit
  end

say "Processing..."
do j = 1 to area.0
   inFile = path'\'area.j'.old'
   outFile = path'\'area.j'.bbs'
   call SysFileTree outFile, 'files.', 'FS'
   if files.0 > 0 then           /* if outfile exists */
      do
         '@copy' outfile infile '>NUL'
         say "  " outfile
         call SysFileDelete(outFile)
      end
   else
      do
         say "  " outfile " not found"
         iterate
      end

   if rc \= 0 then
      do
         say "Error copying " infile " to " outfile
         exit
      end


   rc = stream(outFile, 'C' ,'OPEN WRITE')
   rc = stream(inFile, 'C' ,'OPEN READ')
   i = 0
   do while lines(infile)
     i = i + 1
     line = LineIn(infile)
     if i < startLine then
        do
           call LineOut outFile, line
           iterate
        end
     if substr(line, 1, 1) = " " then
        do
           line = strip(line)
           if substr(line,1,1) = "|" then
              line = substr(line,3,length(line) - 2)
           line = "               " || line
           call LineOut outFile, line
          iterate
        end
     parse var line fileName . . description
     call LineOut outFile, left(fileName,14) || description
  end /* while */
  rc = stream(inFile, 'C' ,'CLOSE')
  rc = stream(outFile, 'C' ,'CLOSE')
end /* do */
exit
