/***************************************************************************/
/*   Areas.cmd for use with Afan The 'Advanced File Area Navigator'        */
/*   Makes the fgroupA.asc file with file descriptions as comments,        */
/*   fgroupA.asc is a listing of all available file areas.                 */
/*   Just cut lines from this file to create the other fgroup?.asc files.  */
/***************************************************************************/

/* ***************************** */
/* Load Rexx Functions if needed */
/* ***************************** */

 if RxFuncQuery("SysLoadFuncs") then do
   rc = RxFuncAdd("SysLoadFuncs","RexxUtil","SysLoadFuncs")
   rc = SysLoadFuncs()
 end

areafile = "\adept\system\file_areas"
outfile = "FgroupA.asc"
call SysFileDelete(outfile)

rc = stream(areafile,'c','open read')
rc = stream(outfile,'c','open write')

  DO WHILE Lines(areafile)
      line = LineIn(areafile)
      parse var line keyword value
  SELECT
      WHEN keyword = 'NAME' THEN
       name = strip(value)
      WHEN keyword = 'NUMBER' THEN
       num = strip(value)
      WHEN keyword = 'DESC' THEN
       desc = strip(value)
      WHEN keyword = 'AREAEND' THEN
       Call LineOut outfile, Left(num,6)''Left(name,18)''desc
      OTHERWISE
       NOP
    END
  END

rc = stream(areafile,'c','close')
rc = stream(outfile,'c','close')
